// Инициализация счетчика страниц
var page_count = 1;

$(document).ready(function() {
    // Обработчик клика по кнопке "Показать ещё"
    $('body').on('click', '#nav-load a', function() {
        page_count = page_count + 1;
        var urlNext = window.location.href + 'page/' + page_count;
        var scrollNext = $(this).offset().top - 200;

        if (urlNext !== undefined) {
            $.ajax({
                url: urlNext,
                beforeSend: function() {
                    ShowLoading('');
                },
                success: function(data) {
                    // Парсим полученные данные, чтобы получить новые блоки
                    var $data = $(data);
                    var $newItems = $data.find('.grid-item');

                    // Добавляем новые блоки в конец контейнера .grid
                    $('.grid').append($newItems);

                    // Обновляем кнопку "Показать ещё"
                    $('#bottom-nav').html($data.find('#bottom-nav').html());

                    // Инициализируем функции для новых элементов
                    $newItems.each(function(index, element) {
                        initializeLazyLoading(element);
                        initializeGridMapHover(element);
                        initializeGridHover(element);
                    });

                    // Прокручиваем страницу к новым элементам
                    $('html, body').animate({ scrollTop: scrollNext }, 800);
                    HideLoading('');
                },
                error: function() {
                    HideLoading('');
                    $('#bottom-nav').remove();
                }
            });
        }
        return false;
    });

    // Делегирование событий для наведения на .grid-ul-col li
    $('body').on('mouseenter', '.grid-ul-col li', function() {
        var li_num = $(this).attr('data-num');
        var li_item = $(this).attr('data-item');

        $('.grid-item[data-id="' + li_item + '"] .grid-map .xfieldimagegallery li').removeClass('act');
        $('.grid-item[data-id="' + li_item + '"] .grid-map .xfieldimagegallery li:nth-child(' + li_num + ')').addClass('act');
    });

    $('body').on('mouseleave', '.grid-ul-col li', function() {
        var li_item = $(this).attr('data-item');

        // Возвращаемся к первому изображению
        $('.grid-item[data-id="' + li_item + '"] .grid-map .xfieldimagegallery li').removeClass('act');
        $('.grid-item[data-id="' + li_item + '"] .grid-map .xfieldimagegallery li:first-child').addClass('act');
    });

    // Первоначальная инициализация функций для существующего контента
    $('.grid-item').each(function(index, element) {
        initializeLazyLoading(element);
        initializeGridMapHover(element);
        initializeGridHover(element);
    });
});

// Функция для инициализации ленивой загрузки первого изображения
function initializeLazyLoading(container = document) {
    // Выбираем только первые изображения в каждом grid-item внутри переданного контейнера
    const lazyImages = container.querySelectorAll(".grid-item .xfieldimagegallery.img_all li:first-child img.teaser-lazy");

    if (lazyImages.length > 0) {
        const imageObserver = new IntersectionObserver(function(entries, observer) {
            entries.forEach(function(entry) {
                if (entry.isIntersecting) {
                    const img = entry.target;
                    if (img.dataset.src) {
                        img.src = img.dataset.src;
                    }
                    observer.unobserve(img);
                }
            });
        }, {
            rootMargin: "0px 0px 100px 0px",
            threshold: 0.01
        });

        lazyImages.forEach(image => {
            imageObserver.observe(image);
        });
    }
}

// Функция для загрузки остальных изображений при наведении на grid-map
function initializeGridMapHover(container = document) {
    const gridMaps = container.querySelectorAll('.grid-item .grid-map');

    gridMaps.forEach(gridMap => {
        gridMap.addEventListener('mouseover', () => {
            // Находим все остальные изображения в текущем grid-item, кроме первого
            const otherImages = gridMap.querySelectorAll('.xfieldimagegallery.img_all li:not(:first-child) img.teaser-lazy');

            otherImages.forEach(img => {
                if (!img.src || img.src.includes('preload.gif')) {
                    if (img.dataset.src) {
                        img.src = img.dataset.src;
                    }
                }
            });
        });
    });
}

// Функция для обработки наведения на навигационные элементы
function initializeGridHover(container = document) {
    // В данном случае мы можем оставить эту функцию пустой или удалить её,
    // если мы используем jQuery-обработчики для наведения на .grid-ul-col li
}
    document.addEventListener("DOMContentLoaded", () => {
        const navItems = document.querySelectorAll(".full-nav li");
        const tabs = document.querySelectorAll(".tab");

        navItems.forEach((item, index) => {
            item.addEventListener("click", () => {
                navItems.forEach(nav => nav.classList.remove("active"));
                tabs.forEach(tab => tab.classList.remove("active"));

                item.classList.add("active");
                tabs[index].classList.add("active");
            });
        });
    });